# -*- coding: utf-8 -*-
##############################################################################
#
#    Odoo, Open Source Management Solution, third party addon
#    Copyright (C) 2017.
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU Affero General Public License as
#    published by the Free Software Foundation, either version 3 of the
#    License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU Affero General Public License for more details.
#
#    You should have received a copy of the GNU Affero General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
##############################################################################

from odoo import fields, models


class PosConfig(models.Model):
    _inherit = 'pos.config'

    iface_barcode_prefixes = fields.Char(string='Scales Barcode Prefixes', help="Allow to list scales barcode prefixes: two digits per prefix separated by pipe |.")
    iface_file_extension = fields.Char(string='File Extension', help="Allow to indicate the scale receipt file extension.")
    iface_local_web_server_url = fields.Char(string='Local Web Server URL', help="Allow to indicate the local web server address or url.")
    iface_local_web_server_port = fields.Char(string='Local Web Server Port', help="Allow to indicate the local web server port.")

